/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.network;

import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.network.IPNetworking;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.teleportation.ClientTeleportationManager;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DimId;
import qouteall.q_misc_util.my_util.SignalArged;

@OnlyIn(value=Dist.CLIENT)
public class IPNetworkingClient {
    public static final SignalArged<Portal> clientPortalSpawnSignal = new SignalArged();
    private static final Minecraft client = Minecraft.m_91087_();

    public static void init() {
    }

    public static boolean handleImmPtlCorePacketClientSide(ResourceLocation packedId, Supplier<FriendlyByteBuf> buf) {
        if (packedId.equals((Object)IPNetworking.id_stcSpawnEntity)) {
            IPNetworkingClient.processStcSpawnEntity(buf.get());
            return true;
        }
        if (packedId.equals((Object)IPNetworking.id_stcDimensionConfirm)) {
            IPNetworkingClient.processStcDimensionConfirm(buf.get());
            return true;
        }
        if (packedId.equals((Object)IPNetworking.id_stcUpdateGlobalPortal)) {
            IPNetworkingClient.processGlobalPortalUpdate(buf.get());
            return true;
        }
        return false;
    }

    private static void processStcSpawnEntity(FriendlyByteBuf buf) {
        String entityTypeString = buf.m_130277_();
        int entityId = buf.readInt();
        ResourceKey<Level> dim = DimId.readWorldId(buf, true);
        CompoundTag compoundTag = buf.m_130260_();
        IPNetworkingClient.processEntitySpawn(entityTypeString, entityId, dim, compoundTag);
    }

    private static void processStcDimensionConfirm(FriendlyByteBuf buf) {
        ResourceKey<Level> dimension = DimId.readWorldId(buf, true);
        Vec3 pos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        MiscHelper.executeOnRenderThread(() -> ClientTeleportationManager.acceptSynchronizationDataFromServer(dimension, pos, false));
    }

    private static void processGlobalPortalUpdate(FriendlyByteBuf buf) {
        ResourceKey<Level> dimension = DimId.readWorldId(buf, true);
        CompoundTag compoundTag = buf.m_130260_();
        MiscHelper.executeOnRenderThread(() -> GlobalPortalStorage.receiveGlobalPortalSync(dimension, compoundTag));
    }

    public static Packet createCtsTeleport(ResourceKey<Level> dimensionBefore, Vec3 posBefore, UUID portalEntityId) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        DimId.writeWorldId(buf, dimensionBefore, true);
        buf.writeDouble(posBefore.f_82479_);
        buf.writeDouble(posBefore.f_82480_);
        buf.writeDouble(posBefore.f_82481_);
        buf.m_130077_(portalEntityId);
        return new ServerboundCustomPayloadPacket(IPNetworking.id_ctsTeleport, buf);
    }

    public static void processEntitySpawn(String entityTypeString, int entityId, ResourceKey<Level> dim, CompoundTag compoundTag) {
        Optional entityType = EntityType.m_20632_((String)entityTypeString);
        if (!entityType.isPresent()) {
            Helper.err("unknown entity type " + entityTypeString);
            return;
        }
        MiscHelper.executeOnRenderThread(() -> {
            client.m_91307_().m_6180_("ip_spawn_entity");
            ClientLevel world = ClientWorldLoader.getWorld(dim);
            Entity entity = ((EntityType)entityType.get()).m_20615_((Level)world);
            entity.m_20258_(compoundTag);
            entity.m_20234_(entityId);
            entity.m_217006_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            world.m_104627_(entityId, entity);
            if (entity instanceof Portal) {
                ClientWorldLoader.getWorld(((Portal)entity).dimensionTo);
                clientPortalSpawnSignal.emit((Portal)entity);
            }
            client.m_91307_().m_7238_();
        });
    }
}

